% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinSearch.BIC.R
\name{BinSearch.BIC}
\alias{BinSearch.BIC}
\title{Example function: Calculating BIC for AR(1) model}
\usage{
BinSearch.BIC(chromosome, plen = 0, Xt)
}
\arguments{
\item{chromosome}{The chromosome consists of the number of changepoints, their
locations, and a value of time series length plus 1 (N+1) indicating the end
of the chromosome.}

\item{plen}{The number of model order parameters that need to be selected.
Since we don't need model order selection in this example, \code{plen} equals
to 0.}

\item{Xt}{The simulated AR(1) time series from \code{ts.sim} function.}
}
\value{
The BIC value of the objective function.
}
\description{
The example objective function for changepoint search via Bayesian
Information Criterion (BIC) for simple AR(1) model from Shi et al. (2022).
The model is expressed as \eqn{X_{t}=\kappa_{t}+\epsilon_{t}}, where
\eqn{\epsilon_{t}} follows a stationary AR(1) process, and \eqn{\kappa_{t}}
denotes the regimen mean.
}
\examples{
Ts = 1000
betaT = c(0.5) # intercept
XMatT = matrix(1, nrow=Ts, ncol=1)
colnames(XMatT) = "intercept"
sigmaT = 1
phiT = c(0.5)
thetaT = NULL
DeltaT = c(2, -2)
Cp.prop = c(1/4, 3/4)
CpLocT = floor(Ts*Cp.prop)

myts = ts.sim(beta=betaT, XMat=XMatT, sigma=sigmaT, phi=phiT, theta=thetaT,
              Delta=DeltaT, CpLoc=CpLocT, seed=1234)

# candidate changepoint configuration
chromosome = c(2, 250, 750, 1001)
BinSearch.BIC(chromosome, Xt=myts)
}
\references{
{
  Shi, X., Gallagher, C., Lund, R., & Killick, R. (2022).
  A comparison of single and multiple changepoint techniques for time series data.
  \emph{Computational Statistics & Data Analysis}, 170, 107433.
}
}
