% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_mean.R
\name{local.refine.univar}
\alias{local.refine.univar}
\title{Local refinement of an initial estimator for univariate mean change points detection.}
\usage{
local.refine.univar(cpt_init, y)
}
\arguments{
\item{cpt_init}{An \code{integer} vector of initial change points estimation (sorted in strictly increasing order).}

\item{y}{A \code{numeric} vector of univariate time series.}
}
\value{
An \code{integer} vector of locally refined change point estimation.
}
\description{
Perform local refinement for univariate mean change points detection.
}
\examples{
set.seed(0)
cpt_true = c(20, 50, 170)
y = rnorm(300) + c(rep(0,20),rep(2,30),rep(0,120),rep(2,130))
gamma_set = 1:5
DP_result = CV.search.DP.univar(y, gamma_set, delta = 5)
min_idx = which.min(DP_result$test_error)
cpt_hat = unlist(DP_result$cpt_hat[min_idx])
Hausdorff.dist(cpt_hat, cpt_true)
cpt_LR = local.refine.univar(cpt_hat, y)
Hausdorff.dist(cpt_LR, cpt_true)
}
\references{
Wang, Yu and Rinaldo (2020) <doi:10.1214/20-EJS1710>.
}
\author{
Haotian Xu
}
