% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numerics-provider.R
\docType{data}
\name{NumericsProvider}
\alias{NumericsProvider}
\title{NumericsProvider}
\description{
NumericsProvider
}
\details{
\strong{Methods}
\itemize{
\item \code{double(n, mean, sd)} - get a double, pulls from normal distribution
\itemize{
\item n: number of values, default: 1
\item mean: mean value, default: 0
\item sd: standard deviation, default: 1
}
\item \code{integer(n, min, max)} - get an integer, runs \code{\link[=sample]{sample()}} on range given
\itemize{
\item n: number of values, default: 1
\item min: minimum value, default: 1
\item max: maximum value, default: 1000
}
\item \code{unif(n, min, max)} - get numbers from the uniform distribution
\itemize{
\item n: number of values, default: 1
\item min: minimum value, default: 0
\item max: maximum value, default: 9999
}
\item \code{norm(n, mean, sd)} - get numbers from the normal distribution
\itemize{
\item n: number of values, default: 1
\item mean: mean value, default: 0
\item sd: standard deviation, default: 1
}
\item \code{lnorm(n, mean, sd)} - get numbers from the lognormal distribution
\itemize{
\item n: number of values, default: 1
\item mean: mean value, default: 0
\item sd: standard deviation, default: 1
}
\item \code{beta(n, shape1, shape2, ncp)} - get numbers from the beta distribution
\itemize{
\item n: number of values, default: 1
\item shape1: non-negative parameters of the Beta distribution
\item shape2: non-negative parameters of the Beta distribution
\item ncp: non-centrality parameter, default: 0
}
}
}
\examples{
z <- NumericsProvider$new()

z$double()
z$double(10)
z$double(10, mean = 100)
z$double(10, mean = 100, sd = 17)

z$integer()
z$integer(10)
z$integer(10, 1, 20)
z$integer(10, 1, 10000000L)

z$unif()
z$norm()
z$lnorm(10)
z$beta(10, 1, 1)
}
\keyword{internal}
