% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numerics-provider.R
\name{NumericsProvider}
\alias{NumericsProvider}
\title{NumericsProvider}
\description{
numeric methods, generate numbers
}
\examples{
z <- NumericsProvider$new()

z$double()
z$double(10)
z$double(10, mean = 100)
z$double(10, mean = 100, sd = 17)

z$integer()
z$integer(10)
z$integer(10, 1, 20)
z$integer(10, 1, 10000000L)

z$unif()
z$norm()
z$lnorm(10)
z$beta(10, 1, 1)
}
\keyword{internal}
\section{Super class}{
\code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{NumericsProvider}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-double}{\code{NumericsProvider$double()}}
\item \href{#method-integer}{\code{NumericsProvider$integer()}}
\item \href{#method-unif}{\code{NumericsProvider$unif()}}
\item \href{#method-norm}{\code{NumericsProvider$norm()}}
\item \href{#method-lnorm}{\code{NumericsProvider$lnorm()}}
\item \href{#method-beta}{\code{NumericsProvider$beta()}}
\item \href{#method-clone}{\code{NumericsProvider$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="bothify">}\href{../../charlatan/html/BaseProvider.html#method-bothify}{\code{charlatan::BaseProvider$bothify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale">}\href{../../charlatan/html/BaseProvider.html#method-check_locale}{\code{charlatan::BaseProvider$check_locale()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="lexify">}\href{../../charlatan/html/BaseProvider.html#method-lexify}{\code{charlatan::BaseProvider$lexify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="numerify">}\href{../../charlatan/html/BaseProvider.html#method-numerify}{\code{charlatan::BaseProvider$numerify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit">}\href{../../charlatan/html/BaseProvider.html#method-random_digit}{\code{charlatan::BaseProvider$random_digit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_not_zero}{\code{charlatan::BaseProvider$random_digit_not_zero()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero_or_empty">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_not_zero_or_empty}{\code{charlatan::BaseProvider$random_digit_not_zero_or_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_or_empty">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_or_empty}{\code{charlatan::BaseProvider$random_digit_or_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element">}\href{../../charlatan/html/BaseProvider.html#method-random_element}{\code{charlatan::BaseProvider$random_element()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element_prob">}\href{../../charlatan/html/BaseProvider.html#method-random_element_prob}{\code{charlatan::BaseProvider$random_element_prob()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_int">}\href{../../charlatan/html/BaseProvider.html#method-random_int}{\code{charlatan::BaseProvider$random_int()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_letter">}\href{../../charlatan/html/BaseProvider.html#method-random_letter}{\code{charlatan::BaseProvider$random_letter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="randomize_nb_elements">}\href{../../charlatan/html/BaseProvider.html#method-randomize_nb_elements}{\code{charlatan::BaseProvider$randomize_nb_elements()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-double"></a>}}
\subsection{Method \code{double()}}{
get a double, pulls from normal distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NumericsProvider$double(n = 1, mean = 0, sd = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(integer) number of values, default: 1}

\item{\code{mean}}{mean value, default: 0}

\item{\code{sd}}{standard deviation, default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-integer"></a>}}
\subsection{Method \code{integer()}}{
get an integer, runs \code{\link[=sample]{sample()}} on range given
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NumericsProvider$integer(n = 1, min = 1, max = 1000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(integer) number of values, default: 1}

\item{\code{min}}{minimum value, default: 1}

\item{\code{max}}{maximum value, default: 1000}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unif"></a>}}
\subsection{Method \code{unif()}}{
get numbers from the uniform distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NumericsProvider$unif(n = 1, min = 0, max = 9999)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(integer) number of values, default: 1}

\item{\code{min}}{minimum value, default: 1}

\item{\code{max}}{maximum value, default: 1000}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-norm"></a>}}
\subsection{Method \code{norm()}}{
get numbers from the normal distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NumericsProvider$norm(n = 1, mean = 0, sd = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(integer) number of values, default: 1}

\item{\code{mean}}{mean value, default: 0}

\item{\code{sd}}{standard deviation, default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-lnorm"></a>}}
\subsection{Method \code{lnorm()}}{
get numbers from the lognormal distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NumericsProvider$lnorm(n = 1, mean = 0, sd = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(integer) number of values, default: 1}

\item{\code{mean}}{mean value, default: 0}

\item{\code{sd}}{standard deviation, default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-beta"></a>}}
\subsection{Method \code{beta()}}{
get numbers from the beta distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NumericsProvider$beta(n = 1, shape1, shape2, ncp = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(integer) number of values, default: 1}

\item{\code{shape1}}{non-negative parameters of the Beta distribution}

\item{\code{shape2}}{non-negative parameters of the Beta distribution}

\item{\code{ncp}}{non-centrality parameter, default: 0}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NumericsProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
