# cheapr 0.5.0

* `sset` is now parallelised when `i` is an 'ALTREP'
compact integer sequence, e.g. `sset(x, 1:10)`.

* `sset` now has an internal range-based subset method for 
'ALTREP' integer sequences made using  `:` for example.

* New function `count_val` as a cheaper alternative to e.g. `sum(x == val)`.

* Negative indexing in `sset` has been improved. 
It is also now partially parallelised.

* Setting `recursive` to false should now be faster.

* 'overview' objects gain an additional list element "print_digits" which 
is passed to the print method in order to correctly round the summary statistics 
without affecting the 'cheapr.digits' option globally.

* `factor_` and `na_rm` now handle data frames.

* A bug in `sset.data.table` that caused further set calculations to produce 
warnings has been fixed.

* `is_na.POSIXlt` and `sset.POSIXlt` have been rewritten to handle unbalanced 
'POSIXlt' objects.

# cheapr 0.4.0

* New function `sset` to consistently subset data frame rows and vectors in 
general.

* `overview` now always returns an object of class "overview". It also returns
the number of observations instead of rows so that it makes sense 
for vector summaries as well as data frame summaries.

* `sequence_` has been optimised and rewritten in C++. It now only checks for
integer overflow when both `from` and `by` are integer vectors.

* The internal function `list_as_df` has been rewritten in C++.

# cheapr 0.3.0 (18-Mar-2024)

* New function `overview` as a cheaper alternative to `summary`.

* All of the `NA` handling functions now fall back to using `is.na` if an appropriate
method cannot be found.

* More support has been added for all objects with an `is.na` method.

# cheapr 0.2.0 (06-Mar-2024)

* `is_na` has been added as an S3 generic function which is parallelised and  internally falls back
on `is.na` if there are no suitable methods.

* Additional list utility functions have been added.

* Limited support for `vctrs_rcrd` objects has been added again. 

* `num_na` and similar functions no longer treat empty data frame rows as single observations but instead return the total number of `NA` values in the data frame.

* Fixed a bug in `row_na_counts` and `col_na_counts` that would cause the 
session to crash when a column variable was a list.

* For the time being, vctrs 'vctrs_rcrd' objects are no longer supported though
this support may be re-added in the future.

# cheapr 0.1.0 (05-Mar-2024)

* CRAN submission accepted.
