% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplexlinear.R
\name{slappx}
\alias{slappx}
\title{Simplex Linear approximation on scattered data}
\usage{
slappx(val, knots, ...)
}
\arguments{
\item{val}{Array or function. Function values in the knots, or the function
itself.}

\item{knots}{matrix. Each column is a point in M-dimensional space.}

\item{...}{Further arguments to the function, if \code{is.function(val)}.}
}
\value{
A \code{function(x)} interpolating the values.
}
\description{
A call \code{fun <- slappx(val, knots)} creates a piecewise multilinear interpolation
on the Delaunay triangulation of the \code{knots}.
}
\note{
By default, the interpolant will yield NaN for points outside the convex hull of the knots,
but some extrapolation will be returned instead if the interpolant is called with the
argument \code{epol=TRUE}.
}
\examples{
knots <- matrix(runif(3*1000), 3)
f <- function(x) exp(-sum(x^2))
g <- slappx(f, knots)
a <- matrix(runif(3*6), 3)
rbind(true=apply(a,2,f), sl=g(a))

}
