% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_list_globals.R
\name{get_no_visible}
\alias{get_no_visible}
\title{List no visible globals from check and separate by category}
\usage{
get_no_visible(path = ".", checks, ...)
}
\arguments{
\item{path}{Path to a package tarball or a directory.}

\item{checks}{Output of \code{\link[rcmdcheck]{rcmdcheck}} if already computed}

\item{...}{Other parameters for \code{\link[rcmdcheck]{rcmdcheck}}}
}
\value{
A list with no visible globals
}
\description{
List no visible globals from check and separate by category
}
\examples{
\dontrun{
# This runs a check of the example package
tempdir <- tempdir()
# Create fake package
usethis::create_package(file.path(tempdir, "checkpackage"), open = FALSE)

# Create function no visible global variables and missing documented functions
cat("
#' Function
#' @importFrom dplyr filter
#' @export
my_fun <- function() {
data \%>\%
filter(col == 3) \%>\%
mutate(new_col = 1) \%>\%
ggplot() +
  aes(x, y, colour = new_col) +
  geom_point()
}
", file = file.path(tempdir, "checkpackage", "R", "function.R"))

path <- file.path(tempdir, "checkpackage")
attachment::att_to_description(path = path)
get_no_visible(path)
}
}
