% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord_res_fun.R
\name{results}
\alias{results}
\title{Summary of 'ord_res' object}
\usage{
results(object)
}
\arguments{
\item{object}{an 'ord_res' object}
}
\value{
It prints a summary of the analysis in the phase space, the reaction
order, and the regression results.
}
\description{
Returns the results of the analyses performed by \code{\link[=det_order]{det_order()}} function.
}
\details{
The function prints:
\enumerate{
\item{the linear regression performed in the phase space, together with
the estimated \emph{n} value and its 95\% confidence interval}
\item{a brief conclusion on the results obtained in the phase space
stating which reaction order should be preferred}
\item{the (non-)linear regression performed with parameters associated
statistics. If a non-linear regression has been performed, the most
common goodness-of-fit measures calculated with \code{\link[=goodness_of_fit]{goodness_of_fit()}}
are printed}
}
}
\examples{
t <- c(0, 4, 8, 12, 16, 20)
conc <- c(1, 0.51, 0.24, 0.12, 0.07, 0.02)
err <- c(0.02, 0.05, 0.04, 0.04, 0.03, 0.02)
dframe <- data.frame(t, conc, err)
res <- det_order(dframe)

results(res)
}
\seealso{
\code{\link[=det_order]{det_order()}}, \code{\link[=kin_regr]{kin_regr()}}, \code{\link[=phase_space]{phase_space()}}
}
