#' childfree: Access and harmonize childfree demographic data
#'
#' @description Reads demographic data from a variety of public data sources,
#'    extracting and harmonizing variables useful for the study of childfree individuals.
#'    The identification of childfree individuals and those with other family statuses
#'    uses the framework described by Neal & Neal (2024).
#'
#'    Data can be generated from:
#'    * Demographic and Health Surveys data using [dhs()]
#'    * Michigan State University State of the State data using [soss()]
#'    * US CDC National Survey of Family Growth data using [nsfg()]
#'
#' An introduction to the package is available using \code{vignette("childfree")}, and the detailed
#'    codebooks generated by these functions are available using \code{vignette("codebooks")}.
#'
#' @references {Neal, Z. P. and Neal, J. W. (2024). A framework for studying adults who neither have nor want children. *The Family Journal, 32*, 121-130. Version of record: \doi{10.1177/10664807231198869} Preprint: \doi{10.31234/osf.io/fa89m}}
#'
#' @name childfree
"_PACKAGE"
NULL
