% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-not-null.R
\name{chk_not_null}
\alias{chk_not_null}
\alias{vld_not_null}
\title{Check not NULL}
\usage{
chk_not_null(x, x_name = NULL)

vld_not_null(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if not NULL using

\code{!is.null(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_not_null}: Validate Not NULL
}}

\examples{

# chk_not_null
try(chk_not_null(NULL))
chk_not_null(1)

# vld_not_null
vld_not_null(1)
vld_not_null(NULL)
}
\seealso{
Other chk_null: \code{\link{chk_null}}
}
\concept{chk_null}
