% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-null.R
\name{chk_null}
\alias{chk_null}
\alias{vld_null}
\title{Check NULL}
\usage{
chk_null(x, x_name = NULL)

vld_null(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} functions throw an informative error if the test fails.

The \code{vld_} functions return a flag indicating whether the test was met.
}
\description{
Checks if NULL using

\code{is.null(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_null}: Validate NULL
}}

\examples{

# chk_null
try(chk_null(1))
chk_null(NULL)

# vld_null
vld_null(NULL)
vld_null(1)
}
\seealso{
Other chk_null: \code{\link{chk_not_null}}
}
\concept{chk_null}
