% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-environment.R
\name{chk_environment}
\alias{chk_environment}
\alias{vld_environment}
\title{Check Environment}
\usage{
chk_environment(x, x_name = NULL)

vld_environment(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if environment using

\code{is.environment(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_environment}: Validate Environment
}}

\examples{

# chk_environment
chk_environment(.GlobalEnv)
try(chk_environment(1))

# vld_environment
vld_environment(1)
vld_environment(list(1))
vld_environment(.GlobalEnv)
vld_environment(environment())
}
\seealso{
Other chk_is: 
\code{\link{chk_array}()},
\code{\link{chk_atomic}()},
\code{\link{chk_function}()},
\code{\link{chk_list}()},
\code{\link{chk_matrix}()},
\code{\link{chk_numeric}()},
\code{\link{chk_s3_class}()},
\code{\link{chk_s4_class}()},
\code{\link{chk_vector}()},
\code{\link{chk_whole_numeric}()}
}
\concept{chk_is}
