% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-dim.R
\name{check_dim}
\alias{check_dim}
\title{Check Dimension}
\usage{
check_dim(x, dim = length, values = numeric(0), x_name = NULL, dim_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{dim}{A function returning a non-negative whole number of the dimension.}

\item{values}{A flag or a whole numeric vector of the value, value range or possible values.}

\item{x_name}{A string of the name of object x or NULL.}

\item{dim_name}{A string of the name of the dim function.}
}
\value{
An informative error if the test fails.
}
\description{
Checks dimension of an object.
}
\examples{
check_dim(1)
try(check_dim(1, values = FALSE))
try(check_dim(1, values = c(10, 2)))
try(check_dim(data.frame(x = 1), dim = nrow, values = c(10, 10, 2)))
}
\seealso{
Other check: 
\code{\link{check_data}()},
\code{\link{check_key}()},
\code{\link{check_names}()},
\code{\link{check_values}()}
}
\concept{check}
