% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-dir.R
\name{chk_dir}
\alias{chk_dir}
\alias{vld_dir}
\title{Check Directory Exists}
\usage{
chk_dir(x, x_name = NULL)

vld_dir(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if directory exists using

\code{vld_string(x) && dir.exists(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_dir}: Validate Directory Exists
}}

\examples{
# chk_dir
chk_dir(tempdir())
try(chk_dir(tempfile()))
# vld_dir
vld_dir(1)
vld_dir(tempdir())
vld_dir(tempfile())
}
\seealso{
Other chk_files: 
\code{\link{chk_ext}()},
\code{\link{chk_file}()}
}
\concept{chk_files}
