% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-wnum.R
\name{chk_wnum}
\alias{chk_wnum}
\alias{vld_wnum}
\title{Check Whole Numeric Scalar}
\usage{
chk_wnum(x, x_name = NULL)

vld_wnum(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if whole numeric scalar using

\code{is.numeric(x) && length(x) == 1L && (is.integer(x) || vld_true(all.equal(x, trunc(x))))}

\lifecycle{soft-deprecated}
}
\section{Functions}{
\itemize{
\item \code{vld_wnum}: Validate Whole Numeric Scalar

\lifecycle{soft-deprecated}
}}

\examples{
# chk_wnum
chk_wnum(1)
try(chk_wnum(1.1))
# vld_wnum
vld_wnum(1)
vld_wnum(double(0))
vld_wnum(NA_real_)
vld_wnum(c(1, 1))
vld_wnum(1L)
}
\seealso{
Other deprecated: 
\code{\link{chk_chr}()},
\code{\link{chk_dbl}()},
\code{\link{chk_deprecated}}
}
\concept{deprecated}
