% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chkpt_setup.R
\name{chkpt_setup}
\alias{chkpt_setup}
\title{Checkpoint Setup}
\usage{
chkpt_setup(iter_sampling, iter_warmup, iter_per_chkpt)
}
\arguments{
\item{iter_sampling}{(positive integer) The number of post-warmup iterations
to run per chain. Note: in the CmdStan User's Guide this
is referred to as num_samples.}

\item{iter_warmup}{(positive integer) The number of warmup iterations to
run per chain. Note: in the CmdStan User's Guide this
is referred to as num_warmup.}

\item{iter_per_chkpt}{(positive integer) The number of iterations per
check point.}
}
\value{
A list with the following:

\itemize{

\item \code{warmup_chkpts}: Number of warmup checkpoints

\item \code{sample_chkpts}: Number of sampling checkpoints

\item \code{total_chkpts}: Total number of checkpoints
(warmup_chkpts + sample_chkpts)

\item \code{iter_per_chkpt}: Iterations per checkpoint

}
}
\description{
Deterimine the number of checkpoints for the warmup and
sampling, given the desired number of iterations for each
and the iterations per checkpoint.
}
\examples{
chkpt_setup <- chkpt_setup(
  iter_sampling = 5000,
  iter_warmup = 2000,
  iter_per_chkpt = 10
)

chkpt_setup
}
