% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearestPath.R
\name{nearestPath}
\alias{nearestPath}
\title{Compute shortest walking paths from case to pump.}
\usage{
nearestPath(pump.select = NULL, vestry = FALSE, weighted = TRUE,
  case.set = "observed", cores = 1L)
}
\arguments{
\item{pump.select}{Numeric. Pump candidates to consider. Default is NULL: all pumps are used. Otherwise, selection by a vector of numeric IDs: 1 to 13 for \code{pumps}; 1 to 14 for \code{pumps.vestry}. Negative selection allowed.}

\item{vestry}{Logical. TRUE uses the 14 pumps from the Vestry Report. FALSE uses the 13 in the original map.}

\item{weighted}{Logical. TRUE computes shortest path in terms of road length. FALSE computes shortest path in terms of the number of nodes.}

\item{case.set}{Character. "observed", "expected", or "snow".}

\item{cores}{Numeric. The number logical cores to use. Default is 1, which is the only possible value for Windows.}
}
\value{
A R list of vectors of nodes.
}
\description{
Compute path from anchor case to nearest pump (or among selected pumps).
}
