% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNeighborhoodWalking.R
\name{addNeighborhoodWalking}
\alias{addNeighborhoodWalking}
\title{Add expected walking neighborhoods.}
\usage{
addNeighborhoodWalking(pump.subset = NULL, pump.select = NULL,
  vestry = FALSE, weighted = TRUE, path = NULL, path.color = NULL,
  path.width = 3, alpha.level = 0.25, polygon.type = "solid",
  polygon.col = NULL, polygon.lwd = 2, multi.core = FALSE,
  dev.mode = FALSE)
}
\arguments{
\item{pump.subset}{Numeric. Vector of numeric pump IDs to subset from the neighborhoods defined by \code{pump.select}. Negative selection possible. \code{NULL} uses all pumps in \code{pump.select}.}

\item{pump.select}{Numeric. Numeric vector of pump IDs that define which pump neighborhoods to consider (i.e., specify the "population"). Negative selection possible. \code{NULL} selects all pumps.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{weighted}{Logical. \code{TRUE} computes shortest path weighted by road length. \code{FALSE} computes shortest path in terms of the number of nodes.}

\item{path}{Character. "expected" or "observed".}

\item{path.color}{Character. Use a single color for all paths. \code{NULL} uses neighborhood colors defined by \code{snowColors()}.}

\item{path.width}{Numeric. Set width of paths.}

\item{alpha.level}{Numeric. Alpha level transparency for area plot: a value in [0, 1].}

\item{polygon.type}{Character. "perimeter" or "solid".}

\item{polygon.col}{Character.}

\item{polygon.lwd}{Numeric.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. See \code{vignette("Parallelization")} for details.}

\item{dev.mode}{Logical. Development mode uses parallel::parLapply().}
}
\description{
Add expected walking neighborhoods.
}
\examples{
\donttest{
streetNameLocator("marshall street", zoom = 0.5)
addNeighborhoodWalking()
}
}
