% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latlongVoronoi.R
\name{latlongVoronoi}
\alias{latlongVoronoi}
\title{Compute Georeferenced Latitude and Longitude of vertices of Voronoi polygons.}
\usage{
latlongVoronoi(pump.select = NULL, vestry = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Vector of numeric pump IDs to define pump neighborhoods (i.e., the "population"). Negative selection possible. \code{NULL} selects all pumps.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry report. \code{FALSE} uses the 13 in the original map.}
}
\description{
Compute Georeferenced Latitude and Longitude of vertices of Voronoi polygons.
}
\examples{
snowMap(latlong = TRUE)
cells <- latlongVoronoi()
invisible(lapply(cells, function(x) polygon(x[, c("lon", "lat")])))
}
