% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/acs.R
\name{state_choropleth_acs}
\alias{state_choropleth_acs}
\title{Create a US State choropleth from ACS data}
\usage{
state_choropleth_acs(tableId, endyear = 2011, span = 5, num_colors = 7,
  zoom = NULL)
}
\arguments{
\item{tableId}{The id of an ACS table}

\item{endyear}{The end year of the survey to use.  See acs.fetch (?acs.fetch) and http://1.usa.gov/1geFSSj for details.}

\item{span}{The span of time to use.  See acs.fetch and http://1.usa.gov/1geFSSj for details.}

\item{num_colors}{The number of colors on the map. A value of 1
will use a continuous scale. A value in [2, 9] will use that many colors.}

\item{zoom}{An optional list of states to zoom in on. Must come from the "name" column in
?state.regions.}
}
\value{
A choropleth.
}
\description{
Creates a choropleth of US States using the US Census' American Community Survey (ACS) data.
Requires the acs package to be installed, and a Census API Key to be set with
the acs's api.key.install function.  Census API keys can be obtained at http://www.census.gov/developers/tos/key_request.html.
}
\examples{
\dontrun{
# median income, default parameters
state_choropleth_acs("B19301")

# continuous scale, zooming in on New York, New Jersey and Connecticut
state_choropleth_acs("B19301", num_colors=1, zoom=c("new york", "new jersey", "connecticut"))
}
}
\references{
Uses the acs package created by Ezra Haber Glenn.
}
\seealso{
\code{api.key.install} in the acs package which sets an Census API key for the acs library

http://factfinder2.census.gov/faces/help/jsf/pages/metadata.xhtml?lang=en&type=survey&id=survey.en.ACS_ACS
which contains a list of all ACS surveys.
}
\keyword{acs}
\keyword{choropleth,}

