% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/county.R
\name{county_choropleth}
\alias{county_choropleth}
\title{Create a choropleth of US Counties}
\usage{
county_choropleth(
  df,
  title = "",
  legend = "",
  num_colors = 7,
  state_zoom = NULL,
  county_zoom = NULL,
  reference_map = FALSE
)
}
\arguments{
\item{df}{A data.frame with a column named "region" and a column named "value".  Elements in 
the "region" column must exactly match how regions are named in the "region" column in county.map.}

\item{title}{An optional title for the map.}

\item{legend}{An optional name for the legend.}

\item{num_colors}{The number of colors to use on the map.  A value of 0 uses 
a divergent scale (useful for visualizing negative and positive numbers), A 
value of 1 uses a continuous scale (useful for visualizing outliers), and a 
value in [2, 9] will use that many quantiles.}

\item{state_zoom}{An optional vector of states to zoom in on. Elements of this vector must exactly 
match the names of states as they appear in the "region" column of ?state.regions.}

\item{county_zoom}{An optional vector of counties to zoom in on. Elements of this vector must exactly 
match the names of counties as they appear in the "region" column of ?county.regions.}

\item{reference_map}{If true, render the choropleth over a reference map from Google Maps.}
}
\description{
The map used is county.map in the choroplethrMaps package.  See country.regions
in the choroplethrMaps package for an object which can help you coerce your regions
into the required format.
}
\examples{
\dontrun{
# default parameters
data(df_pop_county)
county_choropleth(df_pop_county, 
                  title  = "US 2012 County Population Estimates", 
                  legend = "Population")
                  
# zoom in on california and add a reference map
county_choropleth(df_pop_county, 
                  title         = "California County Population Estimates", 
                  legend        = "Population",
                  state_zoom    = "california",
                  reference_map = TRUE)

# continuous scale 
data(df_pop_county)
county_choropleth(df_pop_county, 
                 title      = "US 2012 County Population Estimates", 
                 legend     = "Population", 
                 num_colors = 1, 
                 state_zoom = c("california", "oregon", "washington"))

library(dplyr)
library(choroplethrMaps)
data(county.regions)

# show the population of the 5 counties (boroughs) that make up New York City
nyc_county_names = c("kings", "bronx", "new york", "queens", "richmond")
nyc_county_fips = county.regions \%>\%
  filter(state.name == "new york" & county.name \%in\% nyc_county_names) \%>\%
  select(region)
county_choropleth(df_pop_county, 
                  title        = "Population of Counties in New York City",
                  legend       = "Population",
                  num_colors   = 1,
                  county_zoom = nyc_county_fips$region)
}
}
