% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histograms.R
\name{make_histogram}
\alias{make_histogram}
\title{Create a histogram plot from a data frame through ggplotly}
\usage{
make_histogram(
  dt,
  value,
  groups = NULL,
  binwidth = NULL,
  bins = 30,
  scales = "fixed",
  ggtheme = "minimal",
  x_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = "plasma",
  static = FALSE
)
}
\arguments{
\item{dt}{data.frame containing the data to plot.}

\item{value}{Name of the column to use as values on the y axis of the plot.}

\item{groups}{Name of the column containing the different groups.}

\item{binwidth}{Width of the histogram bins.}

\item{bins}{Number of bins. Overridden by binwidth. Defaults to 30.}

\item{scales}{From ggplot2::facet_wrap: Should scales be 'fixed', 'free', or free in one dimension ('free_x', 'free_y'). Default is 'fixed'.}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required.}

\item{static}{If TRUE, the output will be static ggplot chart instead of an interactive ggplotly chart. Default is FALSE.}
}
\value{
A plotly-ized version of a grouped ggplot histogram plot.
}
\description{
Create a histogram plot from a data frame through ggplotly
}
\examples{
make_histogram(dt = iris,
               value = 'Sepal.Length',
               groups = 'Species')
}
