% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RasterArray-raster.R
\docType{methods}
\name{extract,RasterArray,data.frame-method}
\alias{extract,RasterArray,data.frame-method}
\title{Extraction of values from multiple RasterLayers in a RasterArray object}
\usage{
\S4method{extract}{RasterArray,data.frame}(x, y, by, lng = "plng",
  lat = "plat", force = NULL)
}
\arguments{
\item{x}{(\code{RasterArray}). A set of \code{RasterLayers} that are associated with entries (one dimension) or the rows of \code{x}.}

\item{y}{(\code{matrix} or \code{data.frame}). The data table containing the coordinates and (optionally) 
the indices or names of the associated \code{RasterLayer}s in \code{x}.}

\item{by}{(\code{character} or \code{vector}) The link between \code{x} and \code{y}. If \code{by} is a \code{character}
string then it is expected to be column of \code{x} and should contain the \code{names} or the indices of the
associated \code{RasterLayer}s in \code{x}. If it is a \code{vector} its length should match the number of rows in \code{x}
and it will be used as if it were a column of \code{x}.}

\item{lng}{(\code{character}) A column of \code{x} that includes the paleolongitudes.}

\item{lat}{(\code{character}) A column of \code{x} that includes the paleolatitudes.}

\item{force}{(\code{character}) If set to \code{"numeric"} the \code{by} argument or the column it points to will be converted to
numeric values, and x will be subsetted with \code{numeric} subscripts of the \code{x} \code{RasterArray}. If set to character, the by column (or vector) will be
forced to \code{character} values and will be used as character subscripts.}
}
\value{
A \code{numeric} \code{vector}, \code{matrix} or \code{array} of values.
}
\description{
The function takes a set of time-dependent coordinates and extracts the value they point to from associted RasterLayers in a RasterArray.
}
\examples{
# one pair of random coordinates from Africa
mat <- matrix(c(                
  -1.34, 42.96
), ncol=2, byrow=TRUE) 

# repeat four times
mat<- mat[rep(1,4), ]

# assign default names and age
df<- data.frame(plng=mat[, 1],plat=mat[, 2], age=c(1,3,5, 1))
rownames(df) <- paste("point", 1:nrow(df))

# first coordinate pair will be extrated from RasterLayer 1 ["0"]
# second coordinate pair will be extracted from RasterLayer 3 ["10"]
# thrid coordinate pair will be extracted from RasterLayer 5 ["20"]
# fourth coordinate pair will be extracted from RasterLayer 1 ["0"]
data(dems)
extract(dems, df, by="age")

# by=NULL will be implemented in the next update 
# (all coordinates extracted from all layers)
}
