% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RasterArray-subset.R
\name{subset,RasterArray-method}
\alias{subset,RasterArray-method}
\title{Subset a RasterArray object}
\usage{
\S4method{subset}{RasterArray}(x, i, j, ..., oneDim = FALSE, drop = TRUE)
}
\arguments{
\item{x}{\code{RasterArray} object.}

\item{i}{subscript of the first dimension(rows) or vector-like subsetting.}

\item{j}{subscript of the second dimension (columns).}

\item{...}{subscript of additional dimensions.}

\item{oneDim}{\code{logical} In case of multidimensional \code{RasterArray}s, setting \code{oneDim} to \code{TRUE} allows the application of one dimensional subscripts.}

\item{drop}{\code{logical} in case the result of subsetting is a single element, should the \code{RasterArray} wrapper be dropped and the element be reduced to a single \code{RasterLayer}?}
}
\value{
A \code{RasterLayer} or \code{RasterArray} class object.
}
\description{
Extract subsets of RasterArray class object similarly to a regular array.
}
\examples{
data(dems)
# first 4
subset(dems, i=1:4)
# missing at the end
subset(dems, i=1:12)
# character subscript
subset(dems, i=c("5", "25"))
# logical subscript
subs <- rep(TRUE, length(dems))
subs[1] <- FALSE # remove first
subset(dems, i= subs)
# no drop
subset(dems, i=1, drop=FALSE)
}
