% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RasterArray-raster.R
\name{projectRaster}
\alias{projectRaster}
\alias{projectRaster,RasterArray-method}
\title{Project a RasterArray object}
\usage{
projectRaster(
  from,
  to,
  res,
  crs,
  method = "bilinear",
  alignOnly = FALSE,
  over = FALSE,
  filename = "",
  ...
)

\S4method{projectRaster}{RasterArray}(
  from,
  to,
  res,
  crs,
  method = "bilinear",
  alignOnly = FALSE,
  over = FALSE
)
}
\arguments{
\item{from}{A \code{Raster*} \code{RasterArray} object to project.}

\item{to}{\code{Raster*} object with the parameters to which 'from' should be projected}

\item{res}{single or (vector of) two numerics. To, optionally, set the output resolution if 'to' is missing}

\item{crs}{character or object of class 'CRS'. PROJ.4 description of the coordinate reference system. In projectRaster this is used to set the output CRS if 'to' is missing, or if 'to' has no valid CRS}

\item{method}{method used to compute values for the new RasterLayer. Either 'ngb' (nearest neighbor), which is useful for categorical variables, or 'bilinear' (bilinear interpolation; the default value), which is appropriate for continuous variables.}

\item{alignOnly}{\code{logical}. Use to or other parameters only to align the output (i.e. same origin and resolution), but use the projected extent from from}

\item{over}{\code{logical}. If TRUE wrapping around the date-line is turned off. This can be desirable for global data (to avoid mapping the same areas twice) but it is not desireable in other cases}

\item{filename}{\code{character} output filname. Not applicable for RasterArray class objects.}

\item{...}{additional arguments as for \code{\link[raster]{writeRaster}}.}
}
\value{
A projected \code{RasterArray} class object.
}
\description{
The method implemets the \code{\link[raster]{projectRaster}} function for \code{RasterArray} class objects.
}
\examples{
# project first three to mollweide
data(dems)
suppressWarnings(
  mollDem <- projectRaster(dems[1:3], crs=CRS("+proj=moll"))
)
}
