% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{reference}
\alias{reference}
\title{Retrieve citation of data object}
\usage{
reference(
  src,
  bibtex = FALSE,
  ser = NULL,
  ver = NULL,
  print = TRUE,
  prefix = ""
)
}
\arguments{
\item{src}{(\code{characater}) Object downloaded with \code{\link{fetch}} or the source identifier string.}

\item{bibtex}{(\code{logical}) Should a bibtex be printed/returned?}

\item{ser}{(\code{character}) In case \code{src} is \code{character}, the series identifier.}

\item{ver}{(\code{character}) In case \code{src} is \code{character}, the version identifier.}

\item{print}{(\code{logical}) Should the citations be printed to the console, or returned as a \code{character} vector.}

\item{prefix}{(\code{characater}) In case the output is printed on the console. Use this to include a prefix before every entry.}
}
\value{
By default the function has no return value. If \code{print=FALSE}, the function will return a reference character string.
}
\description{
The function prints or returns the citation string of a chosen object/item.
}
\examples{
# A locally-present object, in package's directory
one <- fetch(src="SOM-zaffos-fragmentation",
  datadir=system.file("extdata", package="chronosphere"))
# its reference
reference(one)
}
