% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_quantile_survreg.R
\name{add_quantile.survreg}
\alias{add_quantile.survreg}
\title{Confidence Intervals for Predicted Survival Time Quantiles of
Accelerated Failure Time Models}
\usage{
\method{add_quantile}{survreg}(
  tb,
  fit,
  p = 0.5,
  name = NULL,
  yhatName = "median_pred",
  confint = TRUE,
  alpha = 0.1,
  ...
)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{survreg}. Predictions are made
with this object.}

\item{p}{A real number between 0 and 1. Sets the probability level
of the quantiles.}

\item{name}{\code{NULL} or a character vector of length 3. If
\code{NULL}, quantiles automatically will be named by
\code{add_quantile}, otherwise, they will be named \code{name}.}

\item{yhatName}{A string. Name of the vector of predictions.}

\item{confint}{A logical. If \code{TRUE}, confidence intervals for
the quantiles are also appended to \code{tb}.}

\item{alpha}{A number. Controls the confidence level of the
confidence intervals if \code{confint = TRUE}.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted medians, level \eqn{p}
    quantiles, and confidence intervals attached.
}
\description{
This function is one of the methods of \code{add_quantile} and is
automatically called when an object of class \code{survreg} is
passed to \code{add_quantile}.
}
\details{
\code{add_quantile.survreg} produces quantiles for the estimated
distribution of survival times from a survreg object. Estimated
quantiles (such as the median survival time) may be calculated for
a range of distributions including lognormal, exponential, weibull,
and loglogistic models. \code{add_quantile.survreg} can compute
quantiles through a parametric method based on the Delta
Method. Generally, this method performs well under a mild to
moderate amount of censoring. Parametric intervals are calculated
using a transformation of the confidence intervals produced by
\code{predict.survreg} and are mathematically identical to intervals
calculated by a manual Delta Method.

Unlike other \code{add_quantile} methods,
\code{add_quantile.survreg} additionally produces confidence
intervals for predicted quantiles by default. This may optionally
be disabled by switching the \code{confint} argument.

Note: Due to a limitation, the \code{Surv} object must be specified in
\code{survreg} function call. See the examples section for one way
to do this.

Note: \code{add_quantile.survreg} cannot inspect the convergence of
\code{fit}. Poor maximum likelihood estimates will result in poor
confidence intervals. Inspect any warning messages given from
\code{survreg}.
}
\examples{
## Define a data set:
tb <- survival::stanford2
## remove a covariate with missing values:
tb <- tb[, 1:4]
## next, create the Surv object inside the survreg call:
fit <- survival::survreg(survival::Surv(time, status) ~ age + I(age^2),
                         data = tb, dist = "lognormal")
## Calculate the level 0.75 quantile wit CIs for that quantile
add_quantile(tb, fit, p = 0.75, name = c("quant", "lwr", "upr"))

## Try a weibull model for the same data:
fit2 <- survival::survreg(survival::Surv(time, status) ~ age + I(age^2),
                          data = tb, dist = "weibull")
## Calculate the level 0.75 quantile with CIs for the quantile
add_quantile(tb, fit2, p = 0.75, name = c("quant", "lwr", "upr"))

}
\references{
For descriptions of the log-location scale models supported:
Meeker, William Q., and Luis A. Escobar. Statistical methods for reliability data. John Wiley & Sons, 2014. (Chapter 4)

For a description of the multivariate Delta method:
Meeker, William Q., and Luis A. Escobar. Statistical methods for reliability data. John Wiley & Sons, 2014. (Appendix B.2)

For a description of Delta Method Confidence Intervals:
Meeker, William Q., and Luis A. Escobar. Statistical methods for reliability data. John Wiley & Sons, 2014. (Chapter 8)
}
\seealso{
\code{\link{add_ci.survreg}} for confidence intervals
    \code{survreg} objects, \code{\link{add_pi.survreg}} for
    prediction intervals of \code{survreg} objects, and
    \code{\link{add_probs.survreg}} for survival probabilities of
    \code{survreg} objects.
}
