% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_parc.R
\name{apply_parc}
\alias{apply_parc}
\title{Apply function over locations in each parcel}
\usage{
apply_parc(xii, parc, FUN = mean, mwall_value = NA, ...)
}
\arguments{
\item{xii}{The \code{"xifti"} data to apply the function over, within each
parcel.}

\item{parc}{The \code{"xifti"} "dlabel" parcellation. Each parcel is defined
by a unique key in the label table. If there are multiple columns, only the
first column will be used. Alternatively, \code{parc} can just be a vector
of keys whose length is the number of data locations in \code{"xii"}.}

\item{FUN}{A function that takes as input an \eqn{M \times N} matrix (\eqn{M}
locations in a given parcel, and \eqn{N} measurements/columns in \code{xii})
and outputs a constant-sized (\eqn{Q}) numeric vector.}

\item{mwall_value}{If there is a medial wall in \code{xii}, what should value
should medial wall locations be replaced with prior to calculation?
Default: \code{NA}.}

\item{...}{Additional arguments to \code{FUN}.}
}
\value{
A \eqn{P \times Q} matrix, where \eqn{P} is the number of parcels and
\eqn{Q} is the length of the output of \code{FUN}. (For \code{mean},
\eqn{Q = 1}).
}
\description{
Apply a function across all locations in each parcel. By default, the mean
value in each parcel is calculated.
}
