% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_mwall.R
\name{move_to_mwall}
\alias{move_to_mwall}
\title{Move data locations to the medial wall}
\usage{
move_to_mwall(xifti, values = c(NA, NaN), drop = FALSE)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{values}{Medial wall values. Default: \code{NA} and \code{NaN}. Data
locations in the left and right cortex that are one of these values (across
all columns) will be moved to the medial wall mask in the metadata.}

\item{drop}{Only used if the \code{"xifti"} has the dlabel intent. Drop the
key(s) in \code{values} from the label tables, for columns in which they no
longer exist? Default: \code{FALSE}.}
}
\value{
The \code{"xifti"} with re-organized data and medial wall masks
}
\description{
Move cortical data locations with a specific value(s) to the medial wall mask.
For example, dlabel CIFTIs often have medial wall vertices set to a specific
key value, rather than a medial wall mask. This function can move those data
locations from the data matrix to the medial wall mask in the metadata.
}
\seealso{
move_from_mwall
}
