% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circa_single.R
\name{circa_single}
\alias{circa_single}
\title{circa_single}
\usage{
circa_single(
  x,
  col_time,
  col_outcome,
  period = 24,
  alpha_threshold = 0.05,
  timeout_n = 10000,
  return_figure = TRUE
)
}
\arguments{
\item{x}{data.frame.  This is the data.frame which contains the rhythmic data in a tidy format.}

\item{col_time}{The name of the column within the data.frame, x, which contains time in hours at which the data were collected.}

\item{col_outcome}{The name of the column within the data.frame, x, which contains outcome measure of interest.}

\item{period}{The period of the rhythm. For circadian rhythms, leave this as the default value, 24.}

\item{alpha_threshold}{The level of alpha for which the presence of rhythmicity is considered. Default is 0.05.}

\item{timeout_n}{The upper limit for the model fitting attempts. Default is 10,000.}

\item{return_figure}{Whether or not to return a ggplot graph of the rhythm and cosine model.}
}
\value{
list
}
\description{
\code{circa_single} performs an analysis on a single rhythmic dataset. It estimates the mesor, amplitude and phase of the data provided.
}
\examples{
df <- make_data(phi1 = 0)
circa_single(x = df, col_time = "time", col_outcome="measure")
}
