% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassFunctions.R
\name{medianDirection}
\alias{medianDirection}
\title{Compute the median direction}
\usage{
medianDirection(th, fastMethod = TRUE)
}
\arguments{
\item{th}{A vector of angles in radians.}

\item{fastMethod}{Logical; If \code{TRUE}, the data is rotated so that the
mean is \code{pi} and linear methods are applied. If \code{FALSE}, the arcs
between each set of data points must be computed, which is much slower. For
data that is very strongly spread out, the fast method might not give the
correct value.}
}
\value{
An angle in radians, the median direction.
}
\description{
This function computes the median direction, which is defined as the middle
observation of the shortest arc containing all observations.
}
\examples{
medianDirection(rvmc(30, 0, 2))
}
