% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassPrintFunctions.R
\name{print_mcmc.circGLM}
\alias{print_mcmc.circGLM}
\title{Print the mcmc results from a circGLM object}
\usage{
print_mcmc.circGLM(m, ...)
}
\arguments{
\item{m}{A \code{circGLM} object.}

\item{...}{Additional arguments to be passed to coda printing functions.}
}
\description{
This prints a number of diagnostics about the results of a \code{circGLM} objects
through  \code{\link[coda]{summary.mcmc}} from the \code{coda} package. In
particular, the standard errors may be of interest.
}
\details{
Note that the standard error and convergence diagnostics computed by
\code{coda} are not necessarily trustworthy.
}
\examples{
print(circGLM(th = rvmc(10, 1, 1)), type = "mcmc", digits = 3)

dat <- generateCircGLMData()
cglmmod <- circGLM(th = dat[, 1], X = dat[, -1])
print(cglmmod, type = "mcmc")
}
\seealso{
\code{\link{print_text.circGLM}},
  \code{\link{print_all.circGLM}},
  \code{\link{print_coef.circGLM}},
  \code{\link{print.circGLM}}.
}
