% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{ccGenomicTrack}
\alias{ccGenomicTrack}
\title{Define a track for genomic data visualization}
\usage{
ccGenomicTrack(
  data = NULL,
  ylim = NULL,
  stack = FALSE,
  numeric.column = NULL,
  jitter = 0,
  panel.fun = function(region, value, ...) {
     NULL
 },
  ...
)
}
\arguments{
\item{data}{A bed-file-like data frame or a list of data frames
}

\item{ylim}{If it is \code{NULL}, the value will be calculated from data. If \code{stack} is set to \code{TRUE}, this value is ignored.
}

\item{stack}{whether to plot in a "stack" mode.
}

\item{numeric.column}{Columns of numeric values in \code{data} that will be used for plotting. 
 If \code{data} is a data frame list, \code{numeric.column} should be either length of one or length of \code{data}.
 If value of \code{numeric.column} is not set, its value will depend on the structure of \code{data}.
 If \code{data} is a data frame, the default value for \code{numeric.column} is all the numeric column starting from the fourth column.
 If \code{data} is a list of data frame, the default value for \code{numeric.column} is a vector which have the same length as \code{data}
 and the value in default \code{numeric.column} is the index of the first numeric column in corresponding data frame.
}

\item{jitter}{Numeric. Only works for adding points in \code{circos.genomicTrackPlotRegion} under \code{stack} mode
}

\item{panel.fun}{Self-defined function which will be applied on each sector. Please not it is different
 from that in \code{\link[circlize]{circos.trackPlotRegion}}. In this function, there are two arguments (\code{region} and \code{value}) plus \code{...}.
 In them, \code{region} is a two-column data frame with start positions and end positions in current genomic category (e.g. chromosome). 
 \code{value} is a data frame which is derived from \code{data} but excluding the first three columns. Rows in \code{value} correspond to 
 rows in \code{region}. \code{...} is mandatory and is used to pass internal parameters to other functions. The definition of
 \code{value} will be different according to different input data (data frame or list of data frame) and different settings (stacked or not), 
 please refer to 'details' section and vignettes to detailed explanation.
}

\item{...}{Pass to \code{\link[circlize]{circos.trackPlotRegion}}.
}
}
\value{
Object \linkS4class{ccGenomicTrack}
}
\description{
Object \linkS4class{ccGenomicTrack} will call the function \link[circlize:circos.genomicTrackPlotRegion]{circlize::circos.genomicTrackPlotRegion} while drawing.
}
\examples{
library(circlizePlus)
cc = ccPlot(initMode = "initializeWithIdeogram",chromosome.index = "chr1", plotType = NULL)
bed = generateRandomBed(nr = 300)
t1 = ccGenomicTrack(bed, panel.fun = function(region, value, ...) {
  circos.genomicPoints(region, value, pch = 16, cex = 0.5, ...)
})
cc+t1
circos.clear()
}
