% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_coci.R
\name{oc_coci}
\alias{oc_coci}
\alias{oc_coci_refs}
\alias{oc_coci_cites}
\alias{oc_coci_meta}
\alias{oc_coci_citation}
\title{COCI: OpenCitations Index of Crossref open
DOI-to-DOI references}
\usage{
oc_coci_refs(doi, exclude = NULL, filter = NULL, sort = NULL, ...)

oc_coci_cites(doi, exclude = NULL, filter = NULL, sort = NULL, ...)

oc_coci_meta(doi, exclude = NULL, filter = NULL, sort = NULL, ...)

oc_coci_citation(oci, ...)
}
\arguments{
\item{doi}{(character) one or more Digital Object Identifiers}

\item{exclude}{(character) a field_name; all the rows that have an empty
value in the field_name specified are removed from the result set}

\item{filter}{\verb{=<field_name>:<operator><value>:} only the rows compliant
with \verb{<value>} are kept in the result set. The parameter \verb{<operation>}
is not mandatory. If \verb{<operation>} is not specified, \verb{<value>} is
interpreted as a regular expression, otherwise it is compared by means
of the specified operation. Possible operators are "=", "<", and ">".
For instance, \verb{filter=title:semantics?} returns all the rows that
contain the string "semantic" or "semantics" in the field title,
while \verb{filter=date:>2016-05} returns all the rows that have a date
greater than May 2016.}

\item{sort}{\verb{=<order>(<field_name>):} sort in ascending (\verb{<order>} set to
"asc") or descending (\verb{<order>} set to "desc") order the rows in the
result set according to the values in \verb{<field_name>}. For instance,
\code{sort=desc(date)} sorts all the rows according to the value specified
in the field date in descending order.}

\item{...}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}

\item{oci}{(character) a single Open Citation Identifier (OCI)}
}
\value{
data.frame, see http://opencitations.net/index/coci/api/v1 for
explanation of the resulting columns
}
\description{
AFAICT this API is a REST wrapper around the SPARQL service
}
\examples{
doi1 <- "10.1108/jd-12-2013-0166"
doi2 <- "10.1371/journal.pgen.1005937"
oci1 <-
 "02001010806360107050663080702026306630509-0200101080636102704000806"

if (
crul::ok(
"http://opencitations.net/index/coci/api/v1/references/10.1108/jd-12-2013-0166",
timeout_ms = 1000L)
) {
try(
  oc_coci_cites(doi1),
  silent = TRUE
)
}

### More examples
\donttest{
# references
oc_coci_refs(doi1, exclude = "oci")
oc_coci_refs(doi1, filter = "date:>2016-05", verbose = TRUE)
oc_coci_refs(doi2)

# citations
oc_coci_cites(doi1, exclude = "oci")
oc_coci_cites(doi2)

# metadata
oc_coci_meta(doi2)
oc_coci_meta(c(doi1, doi2))

# citation - an OCI instead of a DOI
oc_coci_citation(oci1)
}
}
\references{
http://opencitations.net/index/coci/api/v1,
https://github.com/opencitations/api-coci
}
