% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised_segment.R
\name{k_clusters}
\alias{k_clusters}
\title{k-clusters model}
\usage{
k_clusters(data, hyperparameters, verbose = TRUE)
}
\arguments{
\item{data}{data.frame, the data to segment}

\item{hyperparameters}{list of hyperparameters to pass. They include
centers: number of clusters or a set of initial (distinct) cluster centers, or 'auto'. When 'auto' is chosen, the number of clusters is optimised; \cr
iter_max: the maximum number of iterations allowed; 
n_start: how many random sets of cluster centers should be tried;
max_centers: maximum number of clusters when 'auto' option is selected for the centers; 
segmentation_variables: the columns to use to segment on.
standardize: whether to standardize numeric columns.}

\item{verbose}{logical whether information about the clustering procedure should be given.}
}
\value{
A class called "k-clusters" containing a list of the model definition, the hyper-parameters,
a table of outliers, the elbow plot (ggplot object) used to determine the optimal no. of clusters, and
a lookup table containing segment predictions for customers.
}
\description{
k-clusters method for segmentation. It can handle segmentation for both numerical data types only, by using k-means algorithm, and mixed data types (numerical and categorical) by using k-prototypes algorithm
}
