% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{users_patch}
\alias{users_patch}
\title{Update info about a user}
\usage{
users_patch(id, name = NULL, email = NULL, active = NULL,
  primary_group_id = NULL, city = NULL, state = NULL, time_zone = NULL,
  initials = NULL, department = NULL, title = NULL,
  prefers_sms_otp = NULL, group_ids = NULL, vpn_enabled = NULL,
  otp_required_for_login = NULL, phone = NULL, password = NULL)
}
\arguments{
\item{id}{integer required. The ID of this user.}

\item{name}{string optional. The name of this user.}

\item{email}{string optional. The email of this user.}

\item{active}{string optional. The account status of this user.}

\item{primary_group_id}{integer optional. The ID of the primary group of this user.}

\item{city}{string optional. The city of this user.}

\item{state}{string optional. The state of this user.}

\item{time_zone}{string optional. The time zone of this user.}

\item{initials}{string optional. The initials of this user.}

\item{department}{string optional. The deartment of this user.}

\item{title}{string optional. The title of this user.}

\item{prefers_sms_otp}{string optional. The preference for phone authorization of this user}

\item{group_ids}{array optional. An array of ids of all the groups this user is in.}

\item{vpn_enabled}{string optional. The availability of vpn for this user.}

\item{otp_required_for_login}{string optional. The two factor authorization requirement for this user.}

\item{phone}{string optional. The phone number of this user.}

\item{password}{string optional. The password of this user.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this user.}
\item{user}{string, The username of this user.}
\item{name}{string, The name of this user.}
\item{email}{string, The email of this user.}
\item{active}{string, The account status of this user.}
\item{primaryGroupId}{integer, The ID of the primary group of this user.}
\item{groups}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of this group.
\item name string, The name of this group.
\item organizationId integer, The organization associated with this group.
}}
\item{city}{string, The city of this user.}
\item{state}{string, The state of this user.}
\item{timeZone}{string, The time zone of this user.}
\item{initials}{string, The initials of this user.}
\item{department}{string, The deartment of this user.}
\item{title}{string, The title of this user.}
\item{githubUsername}{string, The GitHub username of this user.}
\item{prefersSmsOtp}{string, The preference for phone authorization of this user}
\item{vpnEnabled}{string, The availability of vpn for this user.}
\item{otpRequiredForLogin}{string, The two factor authorization requirement for this user.}
\item{phone}{string, The phone number of this user.}
}
\description{
Update info about a user
}
