% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{services_get_deployments}
\alias{services_get_deployments}
\title{Get details about a ShinyApp deployment}
\usage{
services_get_deployments(service_id, deployment_id)
}
\arguments{
\item{service_id}{integer required. The ID of the owning ShinyApp}

\item{deployment_id}{integer required. The ID for this deployment}
}
\value{
A list containing the following elements:
\item{deploymentId}{integer, The ID for this deployment.}
\item{userId}{integer, The ID of the owner.}
\item{host}{string, Domain of the deployment.}
\item{name}{string, Name of the deployment.}
\item{dockerImageName}{string, The name of the docker image to pull from DockerHub.}
\item{dockerImageTag}{string, The tag of the docker image to pull from DockerHub (default: latest).}
\item{displayUrl}{string, URL that displays the deployed platform object and includes auth token.}
\item{instanceType}{string, The EC2 instance type requested for the deployment.}
\item{memory}{integer, The memory allocated to the deployment.}
\item{cpu}{integer, The cpu allocated to the deployment.}
\item{state}{string, The state of the deployment.}
\item{stateMessage}{string, A detailed description of the state.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{published}{boolean, }
\item{serviceId}{integer, The ID of owning Service}
}
\description{
Get details about a ShinyApp deployment
}
