% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{users_list_me_favorites}
\alias{users_list_me_favorites}
\title{List Favorites}
\usage{
users_list_me_favorites(
  object_id = NULL,
  object_type = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{object_id}{integer optional. The id of the object. If specified as a query parameter, must also specify object_type parameter.}

\item{object_type}{string optional. The type of the object that is favorited. Valid options: Project}

\item{limit}{integer optional. Number of results to return. Defaults to 50. Maximum allowed is 1000.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to created_at. Must be one of: created_at, object_type, object_id.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The id of the favorite.}
\item{objectId}{integer, The id of the object. If specified as a query parameter, must also specify object_type parameter.}
\item{objectType}{string, The type of the object that is favorited. Valid options: Project}
\item{objectName}{string, The name of the object that is favorited.}
\item{createdAt}{string, The time this favorite was created.}
}
\description{
List Favorites
}
