% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_list_kubernetes_instance_configs_active_workloads}
\alias{clusters_list_kubernetes_instance_configs_active_workloads}
\title{List active workloads in an Instance Config}
\usage{
clusters_list_kubernetes_instance_configs_active_workloads(id, state = NULL)
}
\arguments{
\item{id}{integer required. The id of the instance config.}

\item{state}{string optional. If specified, return workloads in these states. It accepts a comma-separated list, possible values are pending, running}
}
\value{
An array containing the following fields:
\item{id}{integer, The id of this deployment.}
\item{baseType}{string, The base type of this deployment.}
\item{baseId}{integer, The id of the base object associated with this deployment.}
\item{baseObjectName}{string, The name of the base object associated with this deployment. Null if you do not have permission to read the object.}
\item{jobType}{string, If the base object is a job run you have permission to read, the type of the job. One of "python_script", "r_script", "container_script", or "custom_script".}
\item{jobId}{integer, If the base object is a job run you have permission to read, the id of the job.}
\item{jobCancelRequestedAt}{string, If the base object is a job run you have permission to read, and it was requested to be cancelled, the timestamp of that request.}
\item{state}{string, The state of this deployment.}
\item{cpu}{integer, The CPU in millicores requested by this deployment.}
\item{memory}{integer, The memory in MB requested by this deployment.}
\item{diskSpace}{integer, The disk space in GB requested by this deployment.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{createdAt}{string, The timestamp of when the deployment began.}
\item{cancellable}{boolean, True if you have permission to cancel this deployment.}
}
\description{
List active workloads in an Instance Config
}
