% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sl_auc_table.R
\name{sl_auc_table}
\alias{sl_auc_table}
\title{Table of cross-validated AUCs from SuperLearner result}
\usage{
sl_auc_table(sl, Y = sl$Y, sort = T)
}
\arguments{
\item{sl}{CV.SuperLearner object}

\item{Y}{Outcome vector, if not already added to SL object.}

\item{sort}{Sort table by order of AUC.}
}
\value{
Dataframe table with auc, se, ci, and p-value (null hypothesis = 0.5).
}
\description{
Calculates cross-validated AUC for each learner in the SuperLearner. Also
calculates standard-error, confidence interval and p-value. Based on initial
code by Alan Hubbard.
}
\examples{
library(SuperLearner)
library(ck37r)

data(Boston, package = "MASS")

set.seed(1)
sl = SuperLearner(Boston$chas, subset(Boston, select = -chas), family = binomial(),
                 SL.library = c("SL.mean", "SL.glmnet"))

sl_auc_table(sl, Y = Boston$chas)

}
\references{
LeDell, E., Petersen, M., & van der Laan, M. (2015). Computationally
efficient confidence intervals for cross-validated area under the ROC curve
estimates. Electronic journal of statistics, 9(1), 1583.

Polley EC, van der Laan MJ (2010) Super Learner in Prediction. U.C. Berkeley
Division of Biostatistics Working Paper Series. Paper 226.
http://biostats.bepress.com/ucbbiostat/paper266/

Sing, T., Sander, O., Beerenwinkel, N., & Lengauer, T. (2005). ROCR:
visualizing classifier performance in R. Bioinformatics, 21(20), 3940-3941.

van der Laan, M. J., Polley, E. C. and Hubbard, A. E. (2007) Super Learner.
Statistical Applications of Genetics and Molecular Biology, 6, article 25.
http://www.degruyter.com/view/j/sagmb.2007.6.issue-1/sagmb.2007.6.1.1309/sagmb.2007.6.1.1309.xml
}
\seealso{
\code{\link{cvsl_auc}} \code{\link{sl_plot_roc}} \code{\link[cvAUC]{ci.cvAUC}}
}
