% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_subject_ids.R
\name{check_subject_ids}
\alias{check_subject_ids}
\title{Check whether the subject IDs comply with the expected format. When incorrect
IDs are found, the function sends a warning and the user can call the
\code{\link{correct_subject_ids}} function to correct them.}
\usage{
check_subject_ids(
  data,
  target_columns,
  prefix = NULL,
  suffix = NULL,
  range = NULL,
  nchar = NULL
)
}
\arguments{
\item{data}{The input \code{<data.frame>} or \code{<linelist>}}

\item{target_columns}{A \code{<vector>} of column names with the subject ids.}

\item{prefix}{A \code{<character>} with the expected prefix used in the
subject IDs}

\item{suffix}{A \code{<character>} with the expected suffix used in the
subject IDs}

\item{range}{A \code{<vector>} with the expected range of numbers in the
subject IDs}

\item{nchar}{An \code{<integer>} that represents the expected number of
characters in the subject ids.}
}
\value{
The input dataset with a warning if incorrect subject ids were found
}
\description{
Check whether the subject IDs comply with the expected format. When incorrect
IDs are found, the function sends a warning and the user can call the
\code{\link{correct_subject_ids}} function to correct them.
}
\examples{
data <- readRDS(
  system.file("extdata", "test_df.RDS", package = "cleanepi")
)

# make first and last subject IDs the same
data$study_id[10] <- data$study_id[1]

# set subject ID number 9 to NA
data$study_id[9] <- NA

# detect the incorrect subject ids i.e. IDs that do not have any or both of
# the followings:
# - starts with 'PS',
# - ends with 'P2',
# - has a number within 1 and 100,
# - contains 7 characters.
dat <- check_subject_ids(
  data = data,
  target_columns = "study_id",
  prefix = "PS",
  suffix = "P2",
  range = c(1, 100),
  nchar = 7
)

# display rows with invalid subject ids
print_report(dat, "incorrect_subject_id")
}
