% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliapp-docs.R
\name{inline-markup}
\alias{inline-markup}
\title{CLI inline markup}
\description{
CLI inline markup
}
\section{Command substitution}{


All text emitted by cli supports glue interpolation. Expressions
enclosed by braces will be evaluated as R code. See \code{\link[glue:glue]{glue::glue()}} for
details.

In addition to regular glue interpolation, cli can also add classes
to parts of the text, and these classes can be used in themes. For
example\preformatted{cli_text("This is \{.emph important\}.")
}

adds a class to the "important" word, class "emph". Note that in this
case the string within the braces is usually not a valid R expression.
If you want to mix classes with interpolation, add another pair of
braces:\preformatted{adjective <- "great"
cli_text("This is \{.emph \{adjective\}\}.")
}

An inline class will always create a \code{span} element internally. So in
themes, you can use the \code{span.emph} CSS selector to change how inline
text is emphasized:\preformatted{cli_div(theme = list(span.emph = list(color = "red")))
adjective <- "nice and red"
cli_text("This is \{.emph \{adjective\}\}.")
}
}

\section{Classes}{


The default theme defines the following inline classes:
\itemize{
\item \code{emph} for emphasized text.
\item \code{strong} for strong importance.
\item \code{code} for a piece of code.
\item \code{pkg} for a package name.
\item \code{fun} for a function name.
\item \code{arg} for a function argument.
\item \code{key} for a keyboard key.
\item \code{file} for a file name.
\item \code{path} for a path (essentially the same as \code{file}).
\item \code{email} for an email address.
\item \code{url} for a URL.
\item \code{var} for a variable name.
\item \code{envvar} for the name of an environment variable.
\item \code{val} for a "value".
}

See examples below.

You can simply add new classes by defining them in the theme, and then
using them, see the example below.
\subsection{Highlighting weird-looking values}{

Often it is useful to highlight a weird file or path name, e.g. one
that starts or ends with space characters. The buildin theme does this
for \code{.file}, \code{.path} and \code{.email} by default. You can highlight
any string inline by adding the \code{.q} class to it.

The current highlighting algorithm
\itemize{
\item adds single quotes to the string if it does not start or end with an
alphanumeric character, underscore, dot or forward slash.
\item Highlights the background colors of leading and trailing spaces on
terminals that support ANSI colors.
}
}
}

\section{Collapsing inline vectors}{


When cli performs inline text formatting, it automatically collapses
glue substitutions, after formatting. This is handy to create lists of
files, packages, etc. See examples below.
}

\section{Formatting values}{


The \code{val} inline class formats values. By default (c.f. the builtin
theme), it calls the \code{\link[=cli_format]{cli_format()}} generic function, with the current
style as the argument. See \code{\link[=cli_format]{cli_format()}} for examples.
}

\section{Escaping \verb{\{} and \verb{\}}}{


It might happen that you want to pass a string to \verb{cli_*} functions,
and you do not_ want command substitution in that string, because it
might contain \verb{\}} and \verb{\{} characters. The simplest solution for this is
referring to the string from a template:\preformatted{msg <- "Error in if (ncol(dat$y)) \{: argument is of length zero"
cli_alert_warning("\{msg\}")
}

If you want to explicitly escape \verb{\{} and \verb{\}} characters, just double
them:\preformatted{cli_alert_warning("A warning with \{\{ braces \}\}")
}

See also examples below.
}

\section{Pluralization}{


All cli commands that emit text support pluralization. Some examples:\preformatted{cli_alert_info("Found \{ndirs\} diretor\{?y/ies\} and \{nfiles\} file\{?s\}.")
cli_text("Will install \{length(pkgs)\} package\{?s\}: \{.pkg \{pkgs\}\}")
}

See \link{pluralization} for details.
}

\examples{
## Some inline markup examples
cli_ul()
cli_li("{.emph Emphasized} text")
cli_li("{.strong Strong} importance")
cli_li("A piece of code: {.code sum(a) / length(a)}")
cli_li("A package name: {.pkg cli}")
cli_li("A function name: {.fn cli_text}")
cli_li("A keyboard key: press {.kbd ENTER}")
cli_li("A file name: {.file /usr/bin/env}")
cli_li("An email address: {.email bugs.bunny@acme.com}")
cli_li("A URL: {.url https://acme.com}")
cli_li("An environment variable: {.envvar R_LIBS}")
cli_end()

## Adding a new class
cli_div(theme = list(
  span.myclass = list(color = "lightgrey"),
  "span.myclass" = list(before = "["),
  "span.myclass" = list(after = "]")))
cli_text("This is {.myclass in brackets}.")
cli_end()

## Collapsing
pkgs <- c("pkg1", "pkg2", "pkg3")
cli_text("Packages: {pkgs}.")
cli_text("Packages: {.pkg {pkgs}}")

## Escaping
msg <- "Error in if (ncol(dat$y)) {: argument is of length zero"
cli_alert_warning("{msg}")

cli_alert_warning("A warning with {{ braces }}")
}
