% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{progress-c}
\alias{progress-c}
\title{The cli progress C API}
\description{
The cli progress C API
}
\section{The cli progress C API}{

\subsection{\code{CLI_SHOULD_TICK}}{

A macro that evaluates to (int) 1 if a cli progress bar update is due,
and to (int) 0 otherwise. If the timer hasn't been initialized in this
compilation unit yet, then it is always 0. To initialize the timer,
call \code{cli_progress_init_timer()} or create a progress bar with
\code{cli_progress_bar()}.
}

\subsection{\code{cli_progress_add()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{void cli_progress_add(SEXP bar, int inc);
}\if{html}{\out{</div>}}

Add a number of progress units to the progress bar. It will also
trigger an update if an update is due.
\itemize{
\item \code{bar}: progress bar object.
\item \code{inc}: progress increment.
}
}

\subsection{\code{cli_progress_bar()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{SEXP cli_progress_bar(int total, SEXP config);
}\if{html}{\out{</div>}}

Create a new progress bar object. The returned progress bar object
must be \code{PROTECT()}-ed.
\itemize{
\item \code{total}: Total number of progress units. Use \code{NA_INTEGER} if it is not
known.
\item \code{config}: R named list object of additional parameters. May be \code{NULL}
(the C \verb{NULL~) or }R_NilValue\verb{(the R}NULL`) for the defaults.
}

\code{config} may contain the following entries:
\itemize{
\item \code{name}: progress bar name.
\item \code{status}: (intiial) progress bar status.
\item \code{type}: progress bar type.
\item \code{total}: total number of progress units.
\item \code{show_after}: show the progress bar after the specified number of
seconds. This overrides the global \code{show_after} option.
\item \code{format}: format string, must be specified for custom progress bars.
\item \code{format_done}: format string for successful termination.
\item \code{format_failed}: format string for unsuccessful termination.
\item \code{clear}: whether to remove the progress bar from the screen after
termination.
\item \code{auto_terminate}: whether to terminate the progress bar when the
number of current units equals the number of total progress units.
}
\subsection{Example}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{#include <cli/progress.h>
SEXP progress_test1() \{
  int i;
  SEXP bar = PROTECT(cli_progress_bar(1000, NULL));
  for (i = 0; i < 1000; i++) \{
    cli_progress_sleep(0, 4 * 1000 * 1000);
    if (CLI_SHOULD_TICK) cli_progress_set(bar, i);
  \}
  cli_progress_done(bar);
  UNPROTECT(1);
  return Rf_ScalarInteger(i);
\}
}\if{html}{\out{</div>}}
}

}

\subsection{\code{cli_progress_done()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{void cli_progress_done(SEXP bar);
}\if{html}{\out{</div>}}

Terminate the progress bar.
\itemize{
\item \code{bar}: progress bar object.
}
}

\subsection{\code{cli_progress_init_timer()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{void cli_progress_init_timer();
}\if{html}{\out{</div>}}

Initialize the cli timer without creating a progress bar.
}

\subsection{\code{cli_progress_num()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{int cli_progress_num();
}\if{html}{\out{</div>}}

Returns the number of currently active progress bars.
}

\subsection{\code{cli_progress_set()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{void cli_progress_set(SEXP bar, int set);
}\if{html}{\out{</div>}}

Set the progress bar to the specified number of progress units.
\itemize{
\item \code{bar}: progress bar object.
\item \code{set}: number of current progress progress units.
}
}

\subsection{\code{cli_progress_set_clear()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{void cli_progress_set_clear(SEXP bar, int clear);
}\if{html}{\out{</div>}}

Set whether to remove the progress bar from the screen. You can call
this any time before \code{cli_progress_done()} is called.
\itemize{
\item \code{bar}: progress bar object.
\item \code{clear}: whether to remove the progress bar from the screen, zero or
one.
}
}

\subsection{\code{cli_progress_set_format()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{void cli_progress_set_format(SEXP bar, const char *format, ...);
}\if{html}{\out{</div>}}

Set a custom format string for the progress bar. This call does not
try to update the progress bar. If you want to request an update,
call \code{cli_progress_add()}, \code{cli_progress_set()} or
\code{cli_progress_update()}.
\itemize{
\item \code{bar}: progress bar object.
\item \code{format}: format string.
\item \code{...}: values to substitute into \code{format}.
}

\code{format} and \code{...} are passed to \code{vsnprintf()} to create a format
string.

Format strings may contain glue substitutions, referring to
\href{https://cli.r-lib.org/dev/reference/progress-variables.html}{progress variables}, pluralization, and cli
styling.
}

\subsection{\code{cli_progress_set_name()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{void cli_progress_set_name(SEXP bar, const char *name);
}\if{html}{\out{</div>}}

Set the name of the progress bar.
\itemize{
\item \code{bar}; progress bar object.
\item \code{name}: progress bar name.
}
}

\subsection{\code{cli_progress_set_status()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{void cli_progress_set_status(SEXP bar, const char *status);
}\if{html}{\out{</div>}}

Set the status of the progress bar.
\itemize{
\item \code{bar}: progress bar object.
\item \code{status }: progress bar status.
}
}

\subsection{\code{cli_progress_set_type()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{void cli_progress_set_type(SEXP bar, const char *type);
}\if{html}{\out{</div>}}

Set the progress bar type. Call this function right after creating
the progress bar with \code{cli_progress_bar()}. Otherwise the behavior is
undefined.
\itemize{
\item \code{bar}: progress bar object.
\item \code{type}: progress bar type. Possible progress bar types:
\code{iterator}, \code{tasks}, \code{download} and \code{custom}.
}
}

\subsection{\code{cli_progress_update()}}{\if{html}{\out{<div class="sourceCode c">}}\preformatted{void cli_progress_update(SEXP bar, int force, int add, int set);
}\if{html}{\out{</div>}}

Update the progress bar. Unlike the simpler \code{cli_progress_add()} and
\code{cli_progress_set()} function, it can force an update if \code{force} is
set to 1.
\itemize{
\item \code{bar}: progress bar object.
\item \code{set}: the number of current progress units. It is ignored if
negative.
\item \code{inc}: increment to add to the current number of progres units.
It is ignored if \code{set} is not negative.
\item \code{force}: whether to force an update, even if no update is due.
}

To force an update without changing the current number of progress units,
supply \code{set = -1}, \code{inc = 0} and \code{force = 1}.
}
}

