% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_functions.R
\name{fix_dates}
\alias{fix_dates}
\alias{fix.dates}
\title{Fix dates}
\usage{
fix_dates(
  x,
  max.NA = 0.8,
  min.obs = nrow(x) * 0.05,
  use.probs = TRUE,
  track = TRUE
)

fix.dates(
  x,
  max.NA = 0.8,
  min.obs = nrow(x) * 0.05,
  use.probs = TRUE,
  track = TRUE
)
}
\arguments{
\item{x}{A data.frame}

\item{max.NA}{Maximum allowed proportion of NA values created by coercion. If the
coercion to date creates more NA values than those specified in \code{max.NA}, then all
changes will be reverted and the variable will remain unchanged.}

\item{min.obs}{Minimum number of non-NA observations allowed per variable. If the variable
has fewer non-NA observations, then it will be ignored by \code{fix.dates}.}

\item{use.probs}{When there are multiple date formats in the same column, there can
be ambiguities. For example, 04-06-2015 can be interpreted as 2015-06-04 or as 2015-04-06.
If \code{use.probs=TRUE}, ambiguities will be solved by assigning to the most frequent
date format in the column.}

\item{track}{Track changes?}
}
\description{
Fixes dates. Dates can be recorded in numerous formats depending on the
country, the traditions and the field of knowledge. \code{fix.dates} tries to detect
all possible date formats and transforms all of them in the ISO standard favored by
R (yyyy-mm-dd).
}
\examples{
mydata<-data.frame(Dates1=c("25/06/1983", "25-08/2014", "2001/11/01", "2008-10-01"),
                   Dates2=c("01/01/85", "04/04/1982", "07/12-2016", "September 24, 2020"),
                   Numeric1=rnorm(4))
fix_dates(mydata)
}
