% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfStation.R
\name{cfStation-class}
\alias{cfStation-class}
\alias{cf_station}
\alias{cfStation}
\title{The Clifro Station Object}
\usage{
cf_station(...)
}
\arguments{
\item{...}{comma separated agent numbers}
}
\value{
\code{cfStation} object
}
\description{
Create a \code{cfStation} object containing station information for one or
more CliFlo stations.
}
\details{
A \code{cfStation} object is created by the constructor function
\code{cf_station}. The unique agent numbers of the stations are all that is
required to create a \code{cfStation} object using the \code{cf_station}
function. The rest of the station information including the name, network and
agent ID, start and end dates, coordinates, as well as other data is scraped
from CliFlo.

This function is used for when the agent numbers are already known. For help
creating \code{cfStation} objects when the agent numbers are unknown see the
\code{\link{cf_find_station}} function.
}
\examples{
\dontrun{
# Create a cfStation object for the Leigh 1 and 2 Ews stations
leigh.st = cf_station(1339, 1340)
leigh.st

# Note, this can also be achieved using the '+' operator
leigh.st = cf_station(1339) + cf_station(1340)
leigh.st

# Add another column showing how long the stations have been open for
leigh.df = as(leigh.st, "data.frame")
leigh.df$ndays = with(leigh.df, round(end - start))
leigh.df

# Save the stations to the current working directory as a KML to visualise
# the station locations
cf_save_kml(leigh.st)
}
}
\seealso{
\code{\link{cf_find_station}} for creating \code{cfStation} objects
when the agent numbers are not known and \code{vignette("cfStation")}
for working with clifro stations including spatial plotting in \R. For saving
\code{cfStation} objects as KML files refer to the vignette or
\code{\link{cf_save_kml}}.
}
