% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripes.R
\name{climatestripes_station}
\alias{climatestripes_station}
\title{Station climate stripes graph}
\usage{
climatestripes_station(
  station,
  start = 1950,
  end = 2020,
  with_labels = "yes",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{station}{Character string with station identifier code(s)
(see \code{\link[=aemet_stations]{aemet_stations()}})}

\item{start}{Numeric value as start year (format: YYYY).}

\item{end}{Numeric value as end year (format: YYYY).}

\item{with_labels}{Character string as yes/no. Indicates whether to use
labels for the graph or not.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{...}{
  Arguments passed on to \code{\link[=ggstripes]{ggstripes}}
  \describe{
    \item{\code{n_temp}}{Numeric value as the number of colors of the palette.
(default 11).}
    \item{\code{col_pal}}{Character string indicating the name of the
\code{\link[=hcl.pals]{hcl.pals()}} color palette to be used for plotting.}
  }}
}
\value{
A \code{ggplot2} object
}
\description{
Plot climate stripes graph for a station
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
climatestripes_station(
  "9434",
  start = 2010,
  end = 2020,
  with_labels = "yes",
  col_pal = "Inferno"
)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=ggstripes]{ggstripes()}}

Other aemet_plots: 
\code{\link{climatogram_normal}()},
\code{\link{climatogram_period}()},
\code{\link{ggclimat_walter_lieth}()},
\code{\link{ggstripes}()},
\code{\link{ggwindrose}()},
\code{\link{windrose_days}()},
\code{\link{windrose_period}()}

Other stripes: 
\code{\link{climaemet_9434_temp}},
\code{\link{ggstripes}()}
}
\concept{aemet_plots}
\concept{stripes}
