% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_daily.R
\name{aemet_daily_clim}
\alias{aemet_daily_clim}
\alias{aemet_daily}
\alias{aemet_daily_period}
\alias{aemet_daily_period_all}
\title{Daily/annual climatology values}
\usage{
aemet_daily_clim(
  station = "all",
  start = Sys.Date() - 7,
  end = Sys.Date(),
  verbose = FALSE,
  return_sf = FALSE
)

aemet_daily_period(
  station,
  start = 2020,
  end = 2020,
  verbose = FALSE,
  return_sf = FALSE
)

aemet_daily_period_all(
  start = 2020,
  end = 2020,
  verbose = FALSE,
  return_sf = FALSE
)
}
\arguments{
\item{station}{Character string with station identifier code(s)
(see \code{\link[=aemet_stations]{aemet_stations()}}) or "all" for all the stations.}

\item{start, end}{Character string with start and end date. See Details.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{sf} spatial object? If \code{FALSE}
(the default value) it returns a tibble. Note that you need to
have the \code{sf} package installed.}
}
\value{
A tibble or a \code{sf} object
}
\description{
Get climatology values for a station or for all the available stations.
Note that \code{aemet_daily_period()} and \code{aemet_daily_period_all()} are shortcuts
of \code{aemet_daily_clim()}.
}
\details{
\code{start} and \code{end} parameters should be:
\itemize{
\item For \code{aemet_daily_clim()}: A \code{Date} object or a string with format:
YYYY-MM-DD (2020-12-31) coercible with \code{\link[=as.Date]{as.Date()}}.
\item For \code{aemet_daily_period()} and \code{aemet_daily_period_all()}: A string
representing the year(s) to be extracted: "2020", "2018".
}
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(tibble)
obs <- aemet_daily_clim(c("9434", "3195"))
glimpse(obs)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=aemet_api_key]{aemet_api_key()}}, \code{\link[=as.Date]{as.Date()}}

Other aemet_api_data: 
\code{\link{aemet_extremes_clim}()},
\code{\link{aemet_forecast_daily}()},
\code{\link{aemet_last_obs}()},
\code{\link{aemet_monthly}},
\code{\link{aemet_normal}},
\code{\link{aemet_stations}()}
}
\concept{aemet_api_data}
