% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_imgw.R
\name{meteo_imgw}
\alias{meteo_imgw}
\title{Meteorological data from IMGW}
\usage{
meteo_imgw(
  interval,
  rank = "synop",
  year,
  status = FALSE,
  coords = FALSE,
  station = NULL,
  col_names = "short",
  ...
)
}
\arguments{
\item{interval}{temporal resolution of the data ("hourly", "daily", "monthly")}

\item{rank}{rank of the stations: "synop" (default), "climate" or "precip"}

\item{year}{vector of years (e.g., 1966:2000)}

\item{status}{leave the columns with measurement and observation statuses (default status = FALSE - i.e. the status columns are deleted)}

\item{coords}{add coordinates of the station (logical value TRUE or FALSE)}

\item{station}{vector of hydrological stations danepubliczne.imgw.pl can be name of station CAPITAL LETTERS(character)
It accepts names (characters in CAPITAL LETTERS) or stations' IDs (numeric)}

\item{col_names}{three types of column names possible: "short" - default, values with shorten names, "full" - full English description, "polish" - original names in the dataset}

\item{...}{other parameters that may be passed to the 'shortening' function that shortens column names}
}
\value{
A data.frame with columns describing the meteorological parameters (e.g. temperature, wind speed, precipitation) where each row represent a measurement,
depending on the interval, at a given hour, month or year. If \code{coords = TRUE} additional two columns with geografic coordinates are added.
}
\description{
Downloading hourly, daily, and monthly meteorological data from the SYNOP / CLIMATE / PRECIP stations available in the danepubliczne.imgw.pl collection
}
\examples{
\donttest{
  x = meteo_imgw("monthly", year = 2018, coords = TRUE)
  head(x)
}
}
