% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/explore.R
\name{explore}
\alias{explore}
\title{Visualise the weight distribution for given parameter values}
\usage{
explore(shape = 0, scale = 1, loc = 0, WeightFunction = "W")
}
\arguments{
\item{shape}{A parameter that determines the shape of the distribution.
Should be greater than 0.}

\item{scale}{A parameter that determines the scale of the distribution.
Should be greater than 0.}

\item{loc}{A parameter that determines the location of the distribution.
Should be less than or equal to 0.}

\item{WeightFunction}{Choose whether to use a weibull ("W") or GEV ("G")
distribution.}
}
\value{
ExploreWeight will return an example plot of the distribution using
  given parameter values. This can be used to select the initial parameter
  values for \code{\link{weightwin}}
}
\description{
Create a plot of the weibell or generalised extreme values (GEV) distribution
for given values of shape, scale and location parameters. Used to determine
initial parameter values for \code{\link{weightwin}}.
}
\examples{
# Test a weibull distribution

explore(shape = 3, scale = 0.2, loc = 0, WeightFunction = "W")

# Test a GEV distribution

explore(shape = 3, scale = 5, loc = -5, WeightFunction = "G")
}
\author{
Martijn van de Pol and Liam D. Bailey
}

