% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render_clinDataReviewReport.R
\name{convertMdToHtml}
\alias{convertMdToHtml}
\title{Convert clinical data Markdown files to HTML}
\usage{
convertMdToHtml(
  outputDir = "./report",
  inputDir = ".",
  configDir = file.path(inputDir, "config"),
  indexPath = file.path(inputDir, "index.Rmd"),
  intermediateDir = "./interim",
  mdFiles = NULL,
  ...
)
}
\arguments{
\item{outputDir}{String with output directory,
('report' by default).}

\item{inputDir}{String with input directory,
working directory by default.}

\item{configDir}{String with directory with config files,
by default a 'config' folder in \code{inputDir}.\cr
It should contain a general 'config.yml' file and dedicated
'config-[X].yml' for each chapter.
The order of each chapter is specified in the 'config' slot in the general 
general 'config.yml'.}

\item{indexPath}{String with path to the index file,
by default 'index.Rmd' in \code{inputDir}.}

\item{intermediateDir}{String with intermediate directory ('interim'
by default), where
markdown files and rds file specifying Js libraries (with \code{knit_meta}) for
each sub report are stored.}

\item{mdFiles}{(optional) Path to the \code{Markdown} files that
should be converted. If specified, the specified config files 
in \code{configDir} are ignored.}

\item{...}{Any parameters passed to \code{\link[rmarkdown]{render}},
for expert use only.}
}
\value{
String with path to the front page of the 
clinical data report.
}
\description{
This consists of:
\enumerate{
\item{importing the general config file ('config'.yml) to identify
each report of interest ('config' tag)}
\item{for each report of interest:
checking if the associated \code{Markdown} and \code{rds} file
(list of Js dependencies) are available in \code{intermediateDir}}
\item{combining all \code{Rmarkdown} reports to a single document: \code{main.md}}
\item{converting \code{main.md} to an HTML document}
}
}
\seealso{
Other clinical data reporting: 
\code{\link{checkReportTitles}()},
\code{\link{forceParams}()},
\code{\link{getMdHeader}()},
\code{\link{getParamsFromConfig}()},
\code{\link{gitbook_clinDataReview_report}()},
\code{\link{html_clinDataReview_report}()},
\code{\link{knitPrintClinDataReview}()},
\code{\link{render_clinDataReviewReport}()}
}
\author{
Laure Cougnaud
}
\concept{clinical data reporting}
